FUNCTION dothread()
    DIM zpulse AS FLOAT
    ' Check if the axes can do this move at the current spindle speed
    IF (accdecratio(TABLE(comms_masterdistx), INT(TABLE(comms_flydistx))) = -1) THEN
        RETURN
    ENDIF
    IF (accdecratio(TABLE(comms_masterdistz), INT(TABLE(comms_flydistz))) = -1) THEN
        RETURN
    ENDIF
    'wait for z pulse here





'  ?"StartedThread",AUXENCODER.0
    'doflyx TABLE(comms_masterdistx),TABLE(comms_flydistx)
    'doflyz TABLE(comms_masterdistz),TABLE(comms_flydistz)
    'doflyx TABLE(comms_masterdistx),-TABLE(comms_flydistx)
ENDFUNC



FUNCTION dosinglethread()
    DIM zpulse AS FLOAT

    ' Check if the axes can do this move at the current spindle speed
    IF accdecratio (TABLE(comms_masterdistz), TABLE(comms_flydistz)) = -1 THEN
        RETURN
    ENDIF

    BASE(3)'where n is the AXIS number
    REGIST(20,0,1,0,0)
    'WAIT UNTIL MARK

    doflyz(TABLE(comms_masterdistz),TABLE(comms_flydistz))
ENDFUNC





FUNCTION accdecratio (spindlecount AS FLOAT, axiscount AS INTEGER) AS FLOAT
    DIM timemain AS FLOAT ' time to do that many spindle counts
    DIM distmain AS FLOAT
    DIM distfull AS FLOAT
    DIM distdiff AS FLOAT
    DIM timeconst AS FLOAT


' Time to do those counts is Dist/Spindle velocity (rev per sec)
' Divide by 2 to get the half velocity graph we use later
' TimeMain = Abs(0.5 *(SpindleCount / ((ActualSpindleSpeed/60)*2000)))
'changed ActualSpindleSpeed to requested so that each thread pass won't fluctuate in velocity graph
' *thread
    IF (VR(vr_machine) = microturnpro) THEN
        timemain = ABS(0.5 *(spindlecount / ((TABLE(comms_speed)/60)*TABLE(comms_encodercount))))'For a 2000 line
'encoder
    ELSE
        timemain = ABS(0.5 *(spindlecount / ((TABLE(comms_speed)/60)*TABLE(comms_encodercount))))'For a 1024 line
'encoder
    ENDIF

' Again half the distance we need to move the axis
    distmain = ABS(0.5 * axiscount)

' DistFull is the biggest distance we could go at current accel in this time
' (1/2  at*t)      nb,COMMS(55) is threading acceleration multiplier
    BASE(0)
    distfull = 0.5 * (TABLE(comms_accelfact)*ACCEL) * (timemain*timemain)

' now calculate difference between distance we could do, and what we actually want
    distdiff = distfull - distmain
    IF distdiff < 0 THEN
            RETURN -1
    ENDIF

' calculate constant speed part of velocity graph
' T= SQRT (2*d/a)
    timeconst = SQR((2*distdiff)/(TABLE(comms_accelfact)*ACCEL))

' so accdec time must be whatever time is left
    RETURN (timemain - timeconst) / timemain
ENDFUNC


FUNCTION doflyx( master AS INTEGER , xlength AS INTEGER )
    DIM ratio AS INTEGER
    ratio = accdecratio (master, xlength)
    IF ratio = -1 THEN RETURN
    accdecfly = ratio * xlength /2
    accdecmaster = ratio * master

    BASE(0)


    IF (VR(vr_machine) = microturnpro) THEN
        MOVELINK(accdecmaster,4000,accdecfly,accdecfly,3)
    ELSE
        MOVELINK(accdecmaster,2048,accdecfly,accdecfly,3)
    ENDIF



ENDFUNC

FUNCTION doflyz( master AS INTEGER , zlength AS INTEGER )
    'zlength is the number of units on axis 1
    'master is the number of encode pulses that will be generated in this time
    DIM ratio AS FLOAT
    'ratio = accdecratio (master, zlength)
    'IF ratio = -1 THEN RETURN
    'accdecfly = ratio * zlength /2

    ' Changes to try make longer threads more accurate
    'IF (accdecfly < 30) THEN ' ratio is too small for the accel to be accurate enough
    '    ratio = ABS((30/zlength)*2)
    '    accdecfly = ratio * zlength /2
    'ENDIF

    'accdecmaster = ratio * master


    BASE(3)'where n is the AXIS number
    REGIST(20,0,1,0,0)
    ' WAIT UNTIL MARK

    BASE(1)

    ' accdecfly = zlength/2'accdecfly/10
    'MOVELINK(zlength,ABS(master),accdecfly,accdecfly,3,1)

    'ACCEL over 2 revs
    'Decel over 1.5 mm

    TABLE(comms_eventthreading,1)
    'Set the spindle speed to be 100% without override before moving the threading
    setspindlespeed()
    rampupspindle()
    WHILE (ABS(TABLE(comms_speed) - TABLE(comms_actualspeed)) > 20)
        WA(100)
    WEND

    'Add two revs for the accel distance, and half that onto the total pulses
    MOVELINK(zlength,ABS(master)+TABLE(comms_encodercount),TABLE(comms_encodercount)*2,0,3,1)

    WAIT IDLE
    TABLE(comms_eventthreading,0)
    setspindlespeed()

ENDFUNC
